-- Create the thermostat weight multiplied version of the annual results (to be summed later), 
--    for SFm also weight values based on the number of stories:
DROP TABLE IF EXISTS sim_annual_twtd;

CREATE TABLE sim_annual_twtd (
"TechID"  TEXT NOT NULL,
"SizingID"  TEXT NOT NULL,
"BldgType"  TEXT NOT NULL,
"BldgVint"  TEXT NOT NULL,
"BldgLoc"  TEXT NOT NULL,
"BldgHVAC"  TEXT NOT NULL,
"tstat"  TEXT NOT NULL,
"normunit"  TEXT,
"numunits"  REAL,
--"measarea"  REAL,
"kwh_tot"  REAL,
"kwh_ltg"  REAL,
"kwh_task"  REAL,
"kwh_equip"  REAL,
"kwh_htg"  REAL,
"kwh_clg"  REAL,
"kwh_twr"  REAL,
"kwh_aux"  REAL,
"kwh_vent"  REAL,
"kwh_venthtg"  REAL,
"kwh_ventclg"  REAL,
"kwh_refg"  REAL,
"kwh_hpsup"  REAL,
"kwh_shw"  REAL,
"kwh_ext"  REAL,
"thm_tot"  REAL,
"thm_equip"  REAL,
"thm_htg"  REAL,
"thm_shw"  REAL,
"deskw_ltg"  REAL,
"deskw_equ"  REAL,
"lastmod"  TEXT,
PRIMARY KEY ("TechID", "SizingID", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC", "tstat")
);



INSERT INTO sim_annual_twtd 
SELECT
sim_annual."TechID",
sim_annual."SizingID",
sim_annual."BldgType" as "BldgType",
sim_annual."BldgVint" as "BldgVint",
sim_annual."BldgLoc" as "BldgLoc",
sim_annual."BldgHVAC" as "BldgHVAC",
sim_annual.tstat as tstat,
sim_annual.normunit,
sim_annual.numunits,
(sim_annual.kwh_tot * tstatwt) as kwh_tot,
(sim_annual.kwh_ltg * tstatwt) as kwh_ltg,
(sim_annual.kwh_task * tstatwt) as kwh_task,
(sim_annual.kwh_equip * tstatwt) as kwh_equip,
(sim_annual.kwh_htg * tstatwt) as kwh_htg,
(sim_annual.kwh_clg * tstatwt) as kwh_clg,
(sim_annual.kwh_twr * tstatwt) as kwh_twr,
(sim_annual.kwh_aux * tstatwt) as kwh_aux,
(sim_annual.kwh_vent * tstatwt) as kwh_vent,
(sim_annual.kwh_venthtg * tstatwt) as kwh_venthtg,
(sim_annual.kwh_ventclg * tstatwt) as kwh_ventclg,
(sim_annual.kwh_refg * tstatwt) as kwh_refg,
(sim_annual.kwh_hpsup * tstatwt) as kwh_hpsup,
(sim_annual.kwh_shw * tstatwt) as kwh_shw,
(sim_annual.kwh_ext * tstatwt) as kwh_ext,
(sim_annual.thm_tot * tstatwt / 1e5) as thm_tot,
(sim_annual.thm_equip * tstatwt / 1e5) as thm_equip,
(sim_annual.thm_htg * tstatwt / 1e5) as thm_htg,
(sim_annual.thm_shw * tstatwt / 1e5) as thm_shw,
(sim_annual.deskw_ltg * tstatwt) as deskw_ltg,
(sim_annual.deskw_equ * tstatwt) as deskw_equ,
lastmod
from sim_annual
JOIN reststatwt on 
 reststatwt.bldgtype = sim_annual."BldgType" and 
 reststatwt.bldgvint = sim_annual."BldgVint" and 
 reststatwt.bldgloc  = sim_annual."BldgLoc"  and 
 reststatwt.tstat = cast(sim_annual.tstat as int2)

UNION

SELECT
sfm_annual."TechID",
sfm_annual."SizingID",
sfm_annual."BldgType" as "BldgType",
sfm_annual."BldgVint" as "BldgVint",
sfm_annual."BldgLoc" as "BldgLoc",
sfm_annual."BldgHVAC" as "BldgHVAC",
sfm_annual.tstat as tstat,
sfm_annual.normunit,
sfm_annual.numunits,
((kwh_tot1 * (2 - numstor) + kwh_tot2 * (numstor - 1)) * tstatwt) AS kwh_tot,
((kwh_ltg1 * (2 - numstor) + kwh_ltg2 * (numstor - 1)) * tstatwt) AS kwh_ltg,
((kwh_task1 * (2 - numstor) + kwh_task2 * (numstor - 1)) * tstatwt) AS kwh_task,
((kwh_equip1 * (2 - numstor) + kwh_equip2 * (numstor - 1)) * tstatwt) AS kwh_equip,
((kwh_htg1 * (2 - numstor) + kwh_htg2 * (numstor - 1)) * tstatwt) AS kwh_htg,
((kwh_clg1 * (2 - numstor) + kwh_clg2 * (numstor - 1)) * tstatwt) AS kwh_clg,
((kwh_twr1 * (2 - numstor) + kwh_twr2 * (numstor - 1)) * tstatwt) AS kwh_twr,
((kwh_aux1 * (2 - numstor) + kwh_aux2 * (numstor - 1)) * tstatwt) AS kwh_aux,
((kwh_vent1 * (2 - numstor) + kwh_vent2 * (numstor - 1)) * tstatwt) AS kwh_vent,
(((kwh_venthtg1a + kwh_venthtg1b) * (2 - numstor) + (kwh_venthtg2a + kwh_venthtg2b)* (numstor - 1)) * tstatwt) AS kwh_venthtg,
(((kwh_ventclg1a + kwh_ventclg1b) * (2 - numstor) + (kwh_ventclg2a + kwh_ventclg2b)* (numstor - 1)) * tstatwt) AS kwh_ventclg,
((kwh_refg1 * (2 - numstor) + kwh_refg2 * (numstor - 1)) * tstatwt) AS kwh_refg,
((kwh_hpsup1 * (2 - numstor) + kwh_hpsup2 * (numstor - 1)) * tstatwt) AS kwh_hpsup,
((kwh_shw1 * (2 - numstor) + kwh_shw2 * (numstor - 1)) * tstatwt) AS kwh_shw,
((kwh_ext1 * (2 - numstor) + kwh_ext2 * (numstor - 1)) * tstatwt) AS kwh_ext,
((thm_tot1 * (2 - numstor) + thm_tot2 * (numstor - 1)) * tstatwt) AS thm_tot,
((thm_equip1 * (2 - numstor) + thm_equip2 * (numstor - 1)) * tstatwt) AS thm_equip,
((thm_htg1 * (2 - numstor) + thm_htg2 * (numstor - 1)) * tstatwt) AS thm_htg,
((thm_shw1 * (2 - numstor) + thm_shw2 * (numstor - 1)) * tstatwt) AS thm_shw,
-1 as deskw_ltg,
-1 as deskw_equ,
lastmod
from sfm_annual
JOIN "NumStor" on "NumStor"."VintYear" = sfm_annual."BldgVint" and "NumStor"."BldgLoc" = sfm_annual."BldgLoc"
JOIN reststatwt on 
 reststatwt.bldgtype = sfm_annual."BldgType" and 
 reststatwt.bldgvint = sfm_annual."BldgVint" and 
 reststatwt.bldgloc  = sfm_annual."BldgLoc"  and 
 reststatwt.tstat    = cast(sfm_annual.tstat as int2)
ORDER BY 
"TechID",
"SizingID",
"BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC",
tstat
;

--ALTER TABLE  "sim_annual_twtd"
--ALTER COLUMN "TechID" SET NOT NULL,
--ALTER COLUMN "SizingID" SET NOT NULL,
--ALTER COLUMN "BldgType" SET NOT NULL,
--ALTER COLUMN "BldgVint" SET NOT NULL,
--ALTER COLUMN "BldgLoc" SET NOT NULL,
--ALTER COLUMN "BldgHVAC" SET NOT NULL,
--ALTER COLUMN "tstat" SET NOT NULL
--;